/*
 * Decompiled with CFR 0.152.
 */
package org.python.jsr223;

import java.io.IOException;
import java.io.StringReader;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.python.core.PyString;

public class ScriptEngineTest
extends TestCase {
    public void testEvalString() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        ScriptEngineTest.assertNull((Object)scriptEngine.eval("x = 5"));
        ScriptEngineTest.assertEquals((Object)5, (Object)scriptEngine.eval("x"));
    }

    public void testSyntaxError() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        try {
            scriptEngine.eval("5q");
        }
        catch (ScriptException scriptException) {
            ScriptEngineTest.assertEquals((int)scriptException.getColumnNumber(), (int)1);
            ScriptEngineTest.assertEquals((int)scriptException.getLineNumber(), (int)1);
            ScriptEngineTest.assertTrue((boolean)scriptException.getMessage().startsWith("SyntaxError: "));
            return;
        }
        ScriptEngineTest.assertTrue((String)"Expected a ScriptException", (boolean)false);
    }

    public void testPythonException() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        try {
            scriptEngine.eval("pass\ndel undefined");
        }
        catch (ScriptException scriptException) {
            ScriptEngineTest.assertEquals((int)scriptException.getLineNumber(), (int)2);
            ScriptEngineTest.assertTrue((boolean)scriptException.getMessage().startsWith("NameError: "));
            return;
        }
        ScriptEngineTest.assertTrue((String)"Expected a ScriptException", (boolean)false);
    }

    public void testScriptFilename() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setAttribute("javax.script.filename", "sample.py", 100);
        try {
            scriptEngine.eval("foo", (ScriptContext)simpleScriptContext);
        }
        catch (ScriptException scriptException) {
            ScriptEngineTest.assertEquals((String)"sample.py", (String)scriptException.getFileName());
            return;
        }
        ScriptEngineTest.assertTrue((String)"Expected a ScriptException", (boolean)false);
    }

    public void testCompileEvalString() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        CompiledScript compiledScript = ((Compilable)((Object)scriptEngine)).compile("5");
        ScriptEngineTest.assertEquals((Object)5, (Object)compiledScript.eval());
    }

    public void testEvalReader() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        ScriptEngineTest.assertNull((Object)scriptEngine.eval(new StringReader("x = 5")));
        ScriptEngineTest.assertEquals((Object)5, (Object)scriptEngine.eval(new StringReader("x")));
    }

    public void testCompileEvalReader() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        CompiledScript compiledScript = ((Compilable)((Object)scriptEngine)).compile(new StringReader("5"));
        ScriptEngineTest.assertEquals((Object)5, (Object)compiledScript.eval());
    }

    public void testBindings() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        scriptEngine.put("a", 42);
        ScriptEngineTest.assertEquals((Object)42, (Object)scriptEngine.eval("a"));
        ScriptEngineTest.assertNull((Object)scriptEngine.eval("x = 5"));
        ScriptEngineTest.assertEquals((Object)5, (Object)scriptEngine.get("x"));
        ScriptEngineTest.assertNull((Object)scriptEngine.eval("del x"));
        ScriptEngineTest.assertNull((Object)scriptEngine.get("x"));
    }

    public void testThreadLocalBindings() throws ScriptException, InterruptedException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        scriptEngine.put("a", 42);
        scriptEngine.put("x", 15);
        ThreadLocalBindingsTest threadLocalBindingsTest = new ThreadLocalBindingsTest(scriptEngine);
        Thread thread2 = new Thread(threadLocalBindingsTest);
        thread2.run();
        thread2.join();
        ScriptEngineTest.assertNull((Object)threadLocalBindingsTest.exception);
        ScriptEngineTest.assertEquals((Object)-7, (Object)threadLocalBindingsTest.x);
        ScriptEngineTest.assertEquals((Object)15, (Object)scriptEngine.get("x"));
        ScriptEngineTest.assertNull((Object)scriptEngine.eval("del x"));
        ScriptEngineTest.assertNull((Object)scriptEngine.get("x"));
    }

    public void testInvoke() throws ScriptException, NoSuchMethodException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        Invocable invocable = (Invocable)((Object)scriptEngine);
        ScriptEngineTest.assertNull((Object)scriptEngine.eval("def f(x): return abs(x)"));
        ScriptEngineTest.assertEquals((Object)5, (Object)invocable.invokeFunction("f", -5));
        ScriptEngineTest.assertEquals((Object)"spam", (Object)invocable.invokeMethod(new PyString("  spam  "), "strip", new Object[0]));
        ScriptEngineTest.assertEquals((Object)"spam", (Object)invocable.invokeMethod("  spam  ", "strip", new Object[0]));
    }

    public void testInvokeFunctionNoSuchMethod() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        Invocable invocable = (Invocable)((Object)scriptEngineManager.getEngineByName("python"));
        try {
            invocable.invokeFunction("undefined", new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        ScriptEngineTest.assertTrue((String)"Expected a NoSuchMethodException", (boolean)false);
    }

    public void testInvokeMethodNoSuchMethod() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        Invocable invocable = (Invocable)((Object)scriptEngineManager.getEngineByName("python"));
        try {
            invocable.invokeMethod("eggs", "undefined", new Object[0]);
            ScriptEngineTest.fail((String)"Expected a NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ScriptEngineTest.assertEquals((String)"undefined", (String)noSuchMethodException.getMessage());
        }
    }

    public void testGetInterface() throws ScriptException, IOException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        Invocable invocable = (Invocable)((Object)scriptEngine);
        ScriptEngineTest.assertNull((Object)scriptEngine.eval("def read(cb): return 1"));
        Readable readable = invocable.getInterface(Readable.class);
        ScriptEngineTest.assertEquals((int)1, (int)readable.read(null));
        ScriptEngineTest.assertNull((Object)scriptEngine.eval("class C(object):\n    def read(self, cb): return 2\nc = C()"));
        readable = invocable.getInterface(scriptEngine.get("c"), Readable.class);
        ScriptEngineTest.assertEquals((int)2, (int)readable.read(null));
    }

    public void testInvokeMethodNoSuchArgs() throws ScriptException, NoSuchMethodException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        Invocable invocable = (Invocable)((Object)scriptEngine);
        Object object = invocable.invokeMethod("test", "capitalize", new Object[0]);
        ScriptEngineTest.assertEquals((Object)object, (Object)"Test");
    }

    public void testPdb() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        String string = "from pdb import set_trace; set_trace()";
        try {
            scriptEngine.eval(string);
            ScriptEngineTest.fail((String)"bdb.BdbQuit expected");
        }
        catch (ScriptException scriptException) {
            ScriptEngineTest.assertTrue((boolean)scriptException.getMessage().startsWith("bdb.BdbQuit"));
        }
    }

    public void testScope_repr() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        scriptEngine.eval("a = 4");
        scriptEngine.eval("b = 'hi'");
        scriptEngine.eval("localrepr = `locals()`");
        ScriptEngineTest.assertEquals((Object)"{'b': u'hi', 'a': 4}", (Object)scriptEngine.get("localrepr"));
    }

    public void testScope_iter() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        scriptEngine.eval("a = 4");
        scriptEngine.eval("b = 'hi'");
        scriptEngine.eval("list = []");
        scriptEngine.eval("for loc in locals(): list.append(loc)");
        scriptEngine.eval("listrepr = `list`");
        ScriptEngineTest.assertEquals((Object)"[u'a', u'b', u'list']", (Object)scriptEngine.get("listrepr"));
    }

    public void testScope_lookup() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        scriptEngine.eval("a = 4");
        scriptEngine.eval("b = 'hi'");
        scriptEngine.eval("var_a = locals()['a']");
        scriptEngine.eval("arepr = `var_a`");
        ScriptEngineTest.assertEquals((Object)"4", (Object)scriptEngine.get("arepr"));
    }

    public void testIssue1681() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        scriptEngine.eval("from org.python.jsr223 import PythonCallable\nclass MyPythonCallable(PythonCallable):\n    def getAString(self): return 'a string'\n\nresult = MyPythonCallable().getAString()\ntest = MyPythonCallable()\nresult2 = test.getAString()");
        ScriptEngineTest.assertEquals((Object)"a string", (Object)scriptEngine.get("result"));
        ScriptEngineTest.assertEquals((Object)"a string", (Object)scriptEngine.get("result2"));
    }

    public void testIssue1698() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("python");
        scriptEngine.eval("import warnings");
        scriptEngine.eval("warnings.warn('test')");
    }

    class ThreadLocalBindingsTest
    implements Runnable {
        ScriptEngine engine;
        Object x;
        Throwable exception;

        public ThreadLocalBindingsTest(ScriptEngine scriptEngine) {
            this.engine = scriptEngine;
        }

        public void run() {
            try {
                Bindings bindings = this.engine.createBindings();
                Assert.assertNull((Object)this.engine.eval("try: a\nexcept NameError: pass\nelse: raise Exception('a is defined', a)", bindings));
                bindings.put("x", (Object)-7);
                this.x = this.engine.eval("x", bindings);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.exception = throwable;
            }
        }
    }
}

